////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/CryptoAppIndex.h>
#import <MSSOrchestration/ProtectionType.h>
NS_ASSUME_NONNULL_BEGIN

@protocol LocalTransactionDelegate;
@class OrchestrationUser;

/**
 * Parameters for performing a local transaction.
 */
NS_REFINED_FOR_SWIFT
@interface LocalTransactionParams : NSObject

/**
 * @return the configured user for performing a local transaction
 */
@property (nonatomic, strong) OrchestrationUser* orchestrationUser;

/**
 * @return the crypto app index used to generate the one-time password.
 */
@property (nonatomic) CryptoAppIndex cryptoAppIndex;

/**
 * @return the data fields used to generate the signature.
 */
@property (nonatomic, strong) NSArray<NSString *> *dataFields;

/**
 * @return the protection type used to generate the one-time password.
 */
@property (nonatomic) ProtectionType protectionType;

/**
 * @return the delegate used to receive events related to local transaction.
 */
@property (nonatomic, weak) id<LocalTransactionDelegate> localTransactionDelegate;

@end

NS_ASSUME_NONNULL_END
